--> Pralable :
/*
USE master;
GO

CREATE DATABASE DB_TEXTE;
GO

USE DB_TEXTE;
GO
*/

CREATE FUNCTION F_DISTANCE_LEVENSHTEIN (@SOURCE nvarchar(4000),
                                        @CIBLE nvarchar(4000),
                                        @d int)
RETURNS int
WITH RETURNS NULL ON NULL INPUT
AS
BEGIN
DECLARE @sl int, @tl int, @i int, @j int, @sc nchar, @c int, @c1 int,
       @cv0 nvarchar(4000), @cv1 nvarchar(4000), @cmin int;

SELECT @sl = LEN(@SOURCE), @tl = LEN(@CIBLE), @cv1 = '', @j = 1, @i = 1, @c = 0;

WHILE @j <= @tl
   SELECT @cv1 = @cv1 + NCHAR(@j), @j = @j + 1;
   WHILE @i <= @sl
   BEGIN
      SELECT @sc = SUBSTRING(@SOURCE, @i, 1), @c1 = @i, @c = @i, @cv0 = '', @j = 1, @cmin = 4000;
      WHILE @j <= @tl
      BEGIN
         SET @c = @c + 1;
         SET @c1 = @c1 - CASE WHEN @sc = SUBSTRING(@CIBLE, @j, 1) THEN 1 ELSE 0 END;
         IF @c > @c1 
            SET @c = @c1
         SET @c1 = UNICODE(SUBSTRING(@cv1, @j, 1)) + 1;
         IF @c > @c1
            SET @c = @c1;
         IF @c < @cmin
            SET @cmin = @c
         SELECT @cv0 = @cv0 + NCHAR(@c), @j = @j + 1;
      END;
      IF @cmin > @d
         BREAK;
      SELECT @cv1 = @cv0, @i = @i + 1;
   END
   RETURN CASE 
             WHEN @cmin <= @d AND @c <= @d 
			    THEN @c 
			 ELSE -1 
          END;
END
GO

CREATE TABLE T_MOT
(MOT_MOT      VARCHAR(36),
 MOT_INVERSE  VARCHAR(36))
GO

/*
INSERT INTO T_MOT  VALUES ('pntrance', 'ecnartnp');
INSERT INTO T_MOT  VALUES ('ptulance', 'ecnalutp');
INSERT INTO T_MOT  VALUES ('subsistance', 'ecnatsisbus');
INSERT INTO T_MOT  VALUES ('suffisance', 'ecnasiffus');
INSERT INTO T_MOT  VALUES ('surabondance', 'ecnadnobarus');
INSERT INTO T_MOT  VALUES ('supplance', 'ecnalppus');
INSERT INTO T_MOT  VALUES ('surintendance', 'ecnadnetnirus');
INSERT INTO T_MOT  VALUES ('survivance', 'ecnavivrus');
INSERT INTO T_MOT  VALUES ('survenance', 'ecnanevrus');
INSERT INTO T_MOT  VALUES ('surveillance', 'ecnallievrus');
INSERT INTO T_MOT  VALUES ('surpuissance', 'ecnassiuprus');
INSERT INTO T_MOT  VALUES ('sance', 'ecnas');
INSERT INTO T_MOT  VALUES ('tance', 'ecnat');
INSERT INTO T_MOT  VALUES ('tendance', 'ecnadnet');
INSERT INTO T_MOT  VALUES ('temprance', 'ecnarpmet');
INSERT INTO T_MOT  VALUES ('thermobalance', 'ecnalabomreht');
INSERT INTO T_MOT  VALUES ('tonitruance', 'ecnaurtinot');
INSERT INTO T_MOT  VALUES ('tolrance', 'ecnarlot');
INSERT INTO T_MOT  VALUES ('transcendance', 'ecnadnecsnart');
INSERT INTO T_MOT  VALUES ('transhumance', 'ecnamuhsnart');
INSERT INTO T_MOT  VALUES ('vacance', 'ecnacav');
INSERT INTO T_MOT  VALUES ('variance', 'ecnairav');
INSERT INTO T_MOT  VALUES ('vaillance', 'ecnalliav');
INSERT INTO T_MOT  VALUES ('vengeance', 'ecnaegnev');
INSERT INTO T_MOT  VALUES ('vigilance', 'ecnaligiv');
INSERT INTO T_MOT  VALUES ('vraisemblance', 'ecnalbmesiarv');
INSERT INTO T_MOT  VALUES ('voyance', 'ecnayov');
INSERT INTO T_MOT  VALUES ('vtrance', 'ecnartv');
INSERT INTO T_MOT  VALUES ('chance', 'ecnahc');
INSERT INTO T_MOT  VALUES ('lance', 'ecnal');
INSERT INTO T_MOT  VALUES ('lgance', 'ecnagl');
INSERT INTO T_MOT  VALUES ('tance', 'ecnat');
INSERT INTO T_MOT  VALUES ('quidistance', 'ecnatsidiuq');
INSERT INTO T_MOT  VALUES ('abondance', 'ecnadnoba');
INSERT INTO T_MOT  VALUES ('aberrance', 'ecnarreba');
INSERT INTO T_MOT  VALUES ('puissance', 'ecnassiup');
INSERT INTO T_MOT  VALUES ('prvoyance', 'ecnayovrp');
INSERT INTO T_MOT  VALUES ('quittance', 'ecnattiuq');
INSERT INTO T_MOT  VALUES ('radiance', 'ecnaidar');
INSERT INTO T_MOT  VALUES ('rance', 'ecnar');
INSERT INTO T_MOT  VALUES ('reconnaissance', 'ecnassiannocer');
INSERT INTO T_MOT  VALUES ('recouvrance', 'ecnarvuocer');
INSERT INTO T_MOT  VALUES ('redondance', 'ecnadnoder');
INSERT INTO T_MOT  VALUES ('redevance', 'ecnaveder');
INSERT INTO T_MOT  VALUES ('relance', 'ecnaler');
INSERT INTO T_MOT  VALUES ('remontrance', 'ecnartnomer');
INSERT INTO T_MOT  VALUES ('remembrance', 'ecnarbmemer');
INSERT INTO T_MOT  VALUES ('renaissance', 'ecnassianer');
INSERT INTO T_MOT  VALUES ('repentance', 'ecnatneper');
INSERT INTO T_MOT  VALUES ('ressemblance', 'ecnalbmesser');
INSERT INTO T_MOT  VALUES ('romance', 'ecnamor');
INSERT INTO T_MOT  VALUES ('rousptance', 'ecnatpsuor');
INSERT INTO T_MOT  VALUES ('ractance', 'ecnatcar');
INSERT INTO T_MOT  VALUES ('rassurance', 'ecnarussar');
INSERT INTO T_MOT  VALUES ('rjouissance', 'ecnassiuojr');
INSERT INTO T_MOT  VALUES ('rpugnance', 'ecnangupr');
INSERT INTO T_MOT  VALUES ('rsonance', 'ecnanosr');
INSERT INTO T_MOT  VALUES ('rsistance', 'ecnatsisr');
INSERT INTO T_MOT  VALUES ('semblance', 'ecnalbmes');
INSERT INTO T_MOT  VALUES ('signifiance', 'ecnaifingis');
INSERT INTO T_MOT  VALUES ('souffrance', 'ecnarffuos');
INSERT INTO T_MOT  VALUES ('soutenance', 'ecnanetuos');
INSERT INTO T_MOT  VALUES ('souvenance', 'ecnanevuos');
INSERT INTO T_MOT  VALUES ('stance', 'ecnats');
INSERT INTO T_MOT  VALUES ('stagnance', 'ecnangats');
INSERT INTO T_MOT  VALUES ('substance', 'ecnatsbus');
INSERT INTO T_MOT  VALUES ('prpondrance', 'ecnardnoprp');
INSERT INTO T_MOT  VALUES ('prsance', 'ecnasrp');
INSERT INTO T_MOT  VALUES ('prvenance', 'ecnanevrp');
INSERT INTO T_MOT  VALUES ('prgnance', 'ecnangrp');
INSERT INTO T_MOT  VALUES ('prdominance', 'ecnanimodrp');
INSERT INTO T_MOT  VALUES ('protubrance', 'ecnarbutorp');
INSERT INTO T_MOT  VALUES ('provenance', 'ecnanevorp');
INSERT INTO T_MOT  VALUES ('prestance', 'ecnatserp');
INSERT INTO T_MOT  VALUES ('portance', 'ecnatrop');
INSERT INTO T_MOT  VALUES ('plaisance', 'ecnasialp');
INSERT INTO T_MOT  VALUES ('pitance', 'ecnatip');
INSERT INTO T_MOT  VALUES ('accointance', 'ecnatniocca');
INSERT INTO T_MOT  VALUES ('naissance', 'ecnassian');
INSERT INTO T_MOT  VALUES ('monstrance', 'ecnartsnom');
INSERT INTO T_MOT  VALUES ('accoutumance', 'ecnamutuocca');
INSERT INTO T_MOT  VALUES ('persistance', 'ecnatsisrep');
INSERT INTO T_MOT  VALUES ('partance', 'ecnatrap');
INSERT INTO T_MOT  VALUES ('nonchalance', 'ecnalahcnon');
INSERT INTO T_MOT  VALUES ('msalliance', 'ecnaillasm');
INSERT INTO T_MOT  VALUES ('mfiance', 'ecnaifm');
INSERT INTO T_MOT  VALUES ('contrebalance', 'ecnalabertnoc');
INSERT INTO T_MOT  VALUES ('assurance', 'ecnarussa');
INSERT INTO T_MOT  VALUES ('attirance', 'ecnaritta');
INSERT INTO T_MOT  VALUES ('avance', 'ecnava');
INSERT INTO T_MOT  VALUES ('balance', 'ecnalab');
INSERT INTO T_MOT  VALUES ('becquetance', 'ecnateuqceb');
INSERT INTO T_MOT  VALUES ('bectance', 'ecnatceb');
INSERT INTO T_MOT  VALUES ('belligrance', 'ecnargilleb');
INSERT INTO T_MOT  VALUES ('bienfaisance', 'ecnasiafneib');
INSERT INTO T_MOT  VALUES ('biensance', 'ecnasneib');
INSERT INTO T_MOT  VALUES ('bienveillance', 'ecnallievneib');
INSERT INTO T_MOT  VALUES ('bombance', 'ecnabmob');
INSERT INTO T_MOT  VALUES ('bouffetance', 'ecnateffuob');
INSERT INTO T_MOT  VALUES ('brillance', 'ecnallirb');
INSERT INTO T_MOT  VALUES ('complaisance', 'ecnasialpmoc');
INSERT INTO T_MOT  VALUES ('concomitance', 'ecnatimocnoc');
INSERT INTO T_MOT  VALUES ('concordance', 'ecnadrocnoc');
INSERT INTO T_MOT  VALUES ('condescendance', 'ecnadnecsednoc');
INSERT INTO T_MOT  VALUES ('condolance', 'ecnalodnoc');
INSERT INTO T_MOT  VALUES ('confiance', 'ecnaifnoc');
INSERT INTO T_MOT  VALUES ('connaissance', 'ecnassiannoc');
INSERT INTO T_MOT  VALUES ('consistance', 'ecnatsisnoc');
INSERT INTO T_MOT  VALUES ('consonance', 'ecnanosnoc');
INSERT INTO T_MOT  VALUES ('constance', 'ecnatsnoc');
INSERT INTO T_MOT  VALUES ('contenance', 'ecnanetnoc');
INSERT INTO T_MOT  VALUES ('covariance', 'ecnairavoc');
INSERT INTO T_MOT  VALUES ('persvrance', 'ecnarvsrep');
INSERT INTO T_MOT  VALUES ('performance', 'ecnamrofrep');
INSERT INTO T_MOT  VALUES ('croissance', 'ecnassiorc');
INSERT INTO T_MOT  VALUES ('outrance', 'ecnartuo');
INSERT INTO T_MOT  VALUES ('outrecuidance', 'ecnadiucertuo');
INSERT INTO T_MOT  VALUES ('ordonnance', 'ecnannodro');
INSERT INTO T_MOT  VALUES ('observance', 'ecnavresbo');
INSERT INTO T_MOT  VALUES ('obissance', 'ecnassibo');
INSERT INTO T_MOT  VALUES ('obligeance', 'ecnaegilbo');
INSERT INTO T_MOT  VALUES ('nuance', 'ecnaun');
INSERT INTO T_MOT  VALUES ('nuisance', 'ecnasiun');
INSERT INTO T_MOT  VALUES ('croyance', 'ecnayorc');
INSERT INTO T_MOT  VALUES ('navrance', 'ecnarvan');
INSERT INTO T_MOT  VALUES ('convenance', 'ecnanevnoc');
INSERT INTO T_MOT  VALUES ('crance', 'ecnarc');
INSERT INTO T_MOT  VALUES ('mconnaissance', 'ecnassiannocm');
INSERT INTO T_MOT  VALUES ('mdisance', 'ecnasidm');
INSERT INTO T_MOT  VALUES ('cuistance', 'ecnatsiuc');
INSERT INTO T_MOT  VALUES ('coordinance', 'ecnanidrooc');
INSERT INTO T_MOT  VALUES ('correspondance', 'ecnadnopserroc');
INSERT INTO T_MOT  VALUES ('mcrance', 'ecnarcm');
INSERT INTO T_MOT  VALUES ('mouvance', 'ecnavuom');
INSERT INTO T_MOT  VALUES ('culminance', 'ecnanimluc');
INSERT INTO T_MOT  VALUES ('aisance', 'ecnasia');
INSERT INTO T_MOT  VALUES ('alliance', 'ecnailla');
INSERT INTO T_MOT  VALUES ('allgeance', 'ecnaeglla');
INSERT INTO T_MOT  VALUES ('alternance', 'ecnanretla');
INSERT INTO T_MOT  VALUES ('ambiance', 'ecnaibma');
INSERT INTO T_MOT  VALUES ('ambulance', 'ecnalubma');
INSERT INTO T_MOT  VALUES ('appartenance', 'ecnanetrappa');
INSERT INTO T_MOT  VALUES ('arrogance', 'ecnagorra');
INSERT INTO T_MOT  VALUES ('ascendance', 'ecnadnecsa');
INSERT INTO T_MOT  VALUES ('assistance', 'ecnatsissa');
INSERT INTO T_MOT  VALUES ('descendance', 'ecnadnecsed');
INSERT INTO T_MOT  VALUES ('disconvenance', 'ecnanevnocsid');
INSERT INTO T_MOT  VALUES ('dissemblance', 'ecnalbmessid');
INSERT INTO T_MOT  VALUES ('dissonance', 'ecnanossid');
INSERT INTO T_MOT  VALUES ('dolance', 'ecnalod');
INSERT INTO T_MOT  VALUES ('dominance', 'ecnanimod');
INSERT INTO T_MOT  VALUES ('dbectance', 'ecnatcebd');
INSERT INTO T_MOT  VALUES ('dchance', 'ecnahcd');
INSERT INTO T_MOT  VALUES ('bance', 'ecnab');
INSERT INTO T_MOT  VALUES ('chance', 'ecnahc');
INSERT INTO T_MOT  VALUES ('chevance', 'ecnavehc');
INSERT INTO T_MOT  VALUES ('circonstance', 'ecnatsnocric');
INSERT INTO T_MOT  VALUES ('clairvoyance', 'ecnayovrialc');
INSERT INTO T_MOT  VALUES ('dfaillance', 'ecnalliafd');
INSERT INTO T_MOT  VALUES ('dfiance', 'ecnaifd');
INSERT INTO T_MOT  VALUES ('devance', 'ecnaved');
INSERT INTO T_MOT  VALUES ('discordance', 'ecnadrocsid');
INSERT INTO T_MOT  VALUES ('dormance', 'ecnamrod');
INSERT INTO T_MOT  VALUES ('dcroissance', 'ecnassiorcd');
INSERT INTO T_MOT  VALUES ('dlinquance', 'ecnauqnild');
INSERT INTO T_MOT  VALUES ('dlivrance', 'ecnarvild');
INSERT INTO T_MOT  VALUES ('dpaissance', 'ecnassiapd');
INSERT INTO T_MOT  VALUES ('dsobligeance', 'ecnaegilbosd');
INSERT INTO T_MOT  VALUES ('endurance', 'ecnarudne');
INSERT INTO T_MOT  VALUES ('engeance', 'ecnaegne');
INSERT INTO T_MOT  VALUES ('errance', 'ecnarre');
INSERT INTO T_MOT  VALUES ('esprance', 'ecnarpse');
INSERT INTO T_MOT  VALUES ('excroissance', 'ecnassiorcxe');
INSERT INTO T_MOT  VALUES ('finance', 'ecnanif');
INSERT INTO T_MOT  VALUES ('fragrance', 'ecnargarf');
INSERT INTO T_MOT  VALUES ('garance', 'ecnarag');
INSERT INTO T_MOT  VALUES ('gourance', 'ecnaruog');
INSERT INTO T_MOT  VALUES ('guidance', 'ecnadiug');
INSERT INTO T_MOT  VALUES ('grance', 'ecnarg');
INSERT INTO T_MOT  VALUES ('ignorance', 'ecnarongi');
INSERT INTO T_MOT  VALUES ('inadvertance', 'ecnatrevdani');
INSERT INTO T_MOT  VALUES ('importance', 'ecnatropmi');
INSERT INTO T_MOT  VALUES ('imprvoyance', 'ecnayovrpmi');
INSERT INTO T_MOT  VALUES ('inconfiance', 'ecnaifnocni');
INSERT INTO T_MOT  VALUES ('impuissance', 'ecnassiupmi');
INSERT INTO T_MOT  VALUES ('inconnaissance', 'ecnassiannocni');
INSERT INTO T_MOT  VALUES ('impdance', 'ecnadpmi');
INSERT INTO T_MOT  VALUES ('inconsistance', 'ecnatsisnocni');
INSERT INTO T_MOT  VALUES ('inconvenance', 'ecnanevnocni');
INSERT INTO T_MOT  VALUES ('incroyance', 'ecnayorcni');
INSERT INTO T_MOT  VALUES ('distance', 'ecnatsid');
INSERT INTO T_MOT  VALUES ('dsesprance', 'ecnarpsesd');
INSERT INTO T_MOT  VALUES ('inconstance', 'ecnatsnocni');
INSERT INTO T_MOT  VALUES ('inductance', 'ecnatcudni');
INSERT INTO T_MOT  VALUES ('indpendance', 'ecnadnepdni');
INSERT INTO T_MOT  VALUES ('insignifiance', 'ecnaifingisni');
INSERT INTO T_MOT  VALUES ('insistance', 'ecnatsisni');
INSERT INTO T_MOT  VALUES ('insouciance', 'ecnaicuosni');
INSERT INTO T_MOT  VALUES ('instance', 'ecnatsni');
INSERT INTO T_MOT  VALUES ('assonance', 'ecnanossa');
INSERT INTO T_MOT  VALUES ('insubstance', 'ecnatsbusni');
INSERT INTO T_MOT  VALUES ('insuffisance', 'ecnasiffusni');
INSERT INTO T_MOT  VALUES ('intemprance', 'ecnarpmetni');
INSERT INTO T_MOT  VALUES ('intendance', 'ecnadnetni');
INSERT INTO T_MOT  VALUES ('interdpendance', 'ecnadnepdretni');
INSERT INTO T_MOT  VALUES ('intolrance', 'ecnarlotni');
INSERT INTO T_MOT  VALUES ('intransigeance', 'ecnaegisnartni');
INSERT INTO T_MOT  VALUES ('invariance', 'ecnairavni');
INSERT INTO T_MOT  VALUES ('invraisemblance', 'ecnalbmesiarvni');
INSERT INTO T_MOT  VALUES ('drogeance', 'ecnaegord');
INSERT INTO T_MOT  VALUES ('dsobissance', 'ecnassibosd');
INSERT INTO T_MOT  VALUES ('dviance', 'ecnaivd');
INSERT INTO T_MOT  VALUES ('fulgurance', 'ecnarugluf');
INSERT INTO T_MOT  VALUES ('maintenus', 'sunetniam');
INSERT INTO T_MOT  VALUES ('maintes', 'setniam');
INSERT INTO T_MOT  VALUES ('maintien', 'neitniam');
INSERT INTO T_MOT  VALUES ('maintiendras', 'sardneitniam');
INSERT INTO T_MOT  VALUES ('maintiendra', 'ardneitniam');
INSERT INTO T_MOT  VALUES ('maintiendrai', 'iardneitniam');
INSERT INTO T_MOT  VALUES ('maintiendraient', 'tneiardneitniam');
INSERT INTO T_MOT  VALUES ('maintiendrait', 'tiardneitniam');
INSERT INTO T_MOT  VALUES ('mainte', 'etniam');
INSERT INTO T_MOT  VALUES ('maintenaient', 'tneianetniam');
INSERT INTO T_MOT  VALUES ('maintenais', 'sianetniam');
INSERT INTO T_MOT  VALUES ('fiance', 'ecnaif');
INSERT INTO T_MOT  VALUES ('maintenait', 'tianetniam');
INSERT INTO T_MOT  VALUES ('maintenance', 'ecnanetniam');
INSERT INTO T_MOT  VALUES ('maintenant', 'tnanetniam');
INSERT INTO T_MOT  VALUES ('mainteneur', 'ruenetniam');
INSERT INTO T_MOT  VALUES ('mainteneurs', 'sruenetniam');
INSERT INTO T_MOT  VALUES ('maintenez', 'zenetniam');
INSERT INTO T_MOT  VALUES ('maintenions', 'snoinetniam');
INSERT INTO T_MOT  VALUES ('maintenir', 'rinetniam');
INSERT INTO T_MOT  VALUES ('maintenons', 'snonetniam');
INSERT INTO T_MOT  VALUES ('maintenu', 'unetniam');
INSERT INTO T_MOT  VALUES ('maintenue', 'eunetniam');
INSERT INTO T_MOT  VALUES ('maintenues', 'seunetniam');
INSERT INTO T_MOT  VALUES ('maintiendriez', 'zeirdneitniam');
INSERT INTO T_MOT  VALUES ('maintiendrons', 'snordneitniam');
INSERT INTO T_MOT  VALUES ('maintiendront', 'tnordneitniam');
INSERT INTO T_MOT  VALUES ('maintienne', 'enneitniam');
INSERT INTO T_MOT  VALUES ('maintiennent', 'tnenneitniam');
INSERT INTO T_MOT  VALUES ('maintiens', 'sneitniam');
INSERT INTO T_MOT  VALUES ('maintient', 'tneitniam');
INSERT INTO T_MOT  VALUES ('maintinrent', 'tnernitniam');
INSERT INTO T_MOT  VALUES ('maintins', 'snitniam');
INSERT INTO T_MOT  VALUES ('luxuriance', 'ecnairuxul');
INSERT INTO T_MOT  VALUES ('maintint', 'tnitniam');
INSERT INTO T_MOT  VALUES ('maints', 'stniam');
INSERT INTO T_MOT  VALUES ('maintnt', 'tntniam');
INSERT INTO T_MOT  VALUES ('laitance', 'ecnatial');
INSERT INTO T_MOT  VALUES ('lieutenance', 'ecnanetueil');
INSERT INTO T_MOT  VALUES ('dpendance', 'ecnadnepd');
INSERT INTO T_MOT  VALUES ('luminance', 'ecnanimul');
INSERT INTO T_MOT  VALUES ('maistrance', 'ecnartsiam');
INSERT INTO T_MOT  VALUES ('malchance', 'ecnahclam');
INSERT INTO T_MOT  VALUES ('malfaisance', 'ecnasiaflam');
INSERT INTO T_MOT  VALUES ('malsance', 'ecnaslam');
INSERT INTO T_MOT  VALUES ('jactance', 'ecnatcaj');
INSERT INTO T_MOT  VALUES ('jouissance', 'ecnassiuoj');
INSERT INTO T_MOT  VALUES ('luisance', 'ecnasiul');
INSERT INTO T_MOT  VALUES ('malveillance', 'ecnallievlam');
INSERT INTO T_MOT  VALUES ('manigance', 'ecnaginam');
INSERT INTO T_MOT  VALUES ('messance', 'ecnassem');
INSERT INTO T_MOT  VALUES ('enfance', 'ecnafne');
INSERT INTO T_MOT  VALUES ('extravagance', 'ecnagavartxe');
INSERT INTO T_MOT  VALUES ('exubrance', 'ecnarbuxe');
INSERT INTO T_MOT  VALUES ('main', 'niam');
INSERT INTO T_MOT  VALUES ('mainate', 'etaniam');
INSERT INTO T_MOT  VALUES ('maincourantier', 'reitnaruocniam');
INSERT INTO T_MOT  VALUES ('mainleve', 'evelniam');
INSERT INTO T_MOT  VALUES ('mainmise', 'esimniam');
INSERT INTO T_MOT  VALUES ('mainmorte', 'etromniam');
INSERT INTO T_MOT  VALUES ('mains', 'sniam');
INSERT INTO T_MOT  VALUES ('maint', 'tniam');
INSERT INTO T_MOT  VALUES ('lance', 'ecnal');
GO

*/

SELECT TOP (5) MOT_MOT,
       dbo.F_DISTANCE_LEVENSHTEIN('maintnance', MOT_MOT, 10) AS MATCH
FROM   T_MOT
WHERE  (MOT_MOT LIKE 'maint%' OR MOT_INVERSE LIKE 'ecnan%')
ORDER  BY MATCH;